/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.patron_pet.entity;

import com.alexander.mutantmore.patron_pet.PatronPetUtils;
import com.alexander.mutantmore.patron_pet.ai.PatronPetFollowOwnerGoal;
import com.alexander.mutantmore.patron_pet.player.PlayerPatronPetDataProvider;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public abstract class AbstractPatronPet
extends PathfinderMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(AbstractPatronPet.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Boolean> SHOULD_SPAWN_PARTICLES = SynchedEntityData.m_135353_(AbstractPatronPet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(AbstractPatronPet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> PLAY_AUDIO = SynchedEntityData.m_135353_(AbstractPatronPet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected AbstractPatronPet(EntityType<? extends AbstractPatronPet> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.f_19850_ = false;
        this.m_20331_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PatronPetFollowOwnerGoal(this, 1.25, 7.5f, 3.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 2.5f, 1.25, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 10.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(SHOULD_SPAWN_PARTICLES, (Object)false);
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(PLAY_AUDIO, (Object)false);
    }

    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
        if (this.getOwnerUUID() != null) {
            p_21819_.m_128362_("Owner", this.getOwnerUUID());
        }
        p_21819_.m_128379_("SpawnsParticles", this.getShouldSpawnParticles());
        p_21819_.m_128379_("Enabled", this.getActive());
        p_21819_.m_128379_("PlayAudio", this.getPlaysAudio());
    }

    public void m_7378_(CompoundTag p_21815_) {
        UUID uuid;
        super.m_7378_(p_21815_);
        if (p_21815_.m_128403_("Owner")) {
            uuid = p_21815_.m_128342_("Owner");
        } else {
            String s = p_21815_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                this.setOwnerUUID(null);
            }
        }
        this.setShouldSpawnParticles(p_21815_.m_128471_("SpawnsParticles"));
        this.setActive(p_21815_.m_128471_("Enabled"));
        this.setPlaysAudio(p_21815_.m_128471_("PlayAudio"));
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_213854_() {
        return true;
    }

    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        return p_27567_ != DamageSource.f_19317_ ? false : super.m_6469_(p_27567_, p_27568_);
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.getOwner() != null) {
            this.getOwner().getCapability(PlayerPatronPetDataProvider.PLAYER_PATRON_PET_DATA).ifPresent(data -> {
                this.setActive(data.getActive());
                this.setShouldSpawnParticles(data.getSpawnParticles());
                this.setPlaysAudio(data.getPlayAudio());
                if (!this.f_19853_.f_46443_ && data.getPetID() != this.m_20148_()) {
                    this.m_146870_();
                }
            });
        }
        if (!this.f_19853_.f_46443_ && this.getOwner() != null) {
            this.m_20225_(!this.getPlaysAudio());
        }
        if (!this.f_19853_.f_46443_ && this.getOwner() != null && !this.getActive()) {
            this.m_146870_();
        }
        if (!this.f_19853_.f_46443_ && this.getOwner() != null && this.m_20270_((Entity)this.getOwner()) > 50.0f) {
            this.m_146870_();
        }
        if (!this.f_19853_.f_46443_ && this.getOwner() != null && !PatronPetUtils.isPlayerAPatron(this.getOwner())) {
            this.m_146870_();
        }
        if (!this.f_19853_.f_46443_ && this.getOwner() == null) {
            this.m_146870_();
        }
        if (!this.f_19853_.f_46443_ && this.getOwnerUUID() == null) {
            this.m_146870_();
        }
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_7337_(Entity p_20303_) {
        return false;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    protected void m_6138_() {
    }

    public InteractionResult m_6071_(Player player, InteractionHand p_27585_) {
        if (this.getOwner() != null && player == this.getOwner()) {
            if (!player.m_6144_()) {
                if (this.f_19853_.f_46443_) {
                    PatronPetUtils.displayPatronPetGUI(this.getShouldSpawnParticles(), this.getActive(), this.getPlaysAudio());
                }
            } else if (!this.m_20159_()) {
                this.m_7998_(this.getTopPassenger((Entity)player), true);
            } else {
                this.dismountFromHead();
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.FAIL;
    }

    private Entity getTopPassenger(Entity entity) {
        List list = entity.m_20197_();
        return !list.isEmpty() ? this.getTopPassenger((Entity)list.get(0)) : entity;
    }

    public double m_6049_() {
        return this.getOwner().m_21255_() || this.getOwner().m_6069_() ? 0.0 : 0.5;
    }

    public boolean canRiderInteract() {
        return true;
    }

    protected int m_7302_(int p_28882_) {
        return p_28882_;
    }

    public void dismountFromHead() {
        Entity entity = this.m_20202_();
        super.m_8127_();
        if (entity != null && entity != this.m_20202_() && !this.f_19853_.f_46443_) {
            this.dismountVehicle(entity);
        }
    }

    private void dismountVehicle(Entity p_21029_) {
        Vec3 vec3;
        if (this.m_213877_()) {
            vec3 = this.m_20182_();
        } else if (!p_21029_.m_213877_() && !this.f_19853_.m_8055_(p_21029_.m_20183_()).m_204336_(BlockTags.f_13075_)) {
            vec3 = p_21029_.m_7688_((LivingEntity)this);
        } else {
            double d0 = Math.max(this.m_20186_(), p_21029_.m_20186_());
            vec3 = new Vec3(this.m_20185_(), d0, this.m_20189_());
        }
        this.m_142098_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public void m_8127_() {
        if (this.getOwner() != null && !this.getOwner().m_20197_().contains((Object)this)) {
            super.m_8127_();
        }
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (p_146834_.m_146965_()) {
            this.dismountFromHead();
        }
        this.m_142467_(p_146834_);
        this.invalidateCaps();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getShouldSpawnParticles()) {
            this.spawnParticles();
        }
    }

    public void spawnParticles() {
    }

    public boolean m_6573_(Player p_21813_) {
        return !this.m_21523_();
    }

    public Player getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(p_21817_));
    }

    public boolean getShouldSpawnParticles() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_SPAWN_PARTICLES);
    }

    public void setShouldSpawnParticles(boolean setTo) {
        this.f_19804_.m_135381_(SHOULD_SPAWN_PARTICLES, (Object)setTo);
    }

    public boolean getActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setActive(boolean setTo) {
        this.f_19804_.m_135381_(ACTIVE, (Object)setTo);
    }

    public boolean getPlaysAudio() {
        return (Boolean)this.f_19804_.m_135370_(PLAY_AUDIO);
    }

    public void setPlaysAudio(boolean setTo) {
        this.f_19804_.m_135381_(PLAY_AUDIO, (Object)setTo);
    }
}

